/***************************************************************************
 *   Copyright (C) 2015 by Laboratoire d'Economie Forestière               *
 *   http://ffsm-project.org                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 3 of the License, or     *
 *   (at your option) any later version, given the compliance with the     *
 *   exceptions listed in the file COPYING that is distribued together     *
 *   with this file.                                                       *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef MODELREGION_H
#define MODELREGION_H

// Core C++ headers
#include <string>
#include <vector>
#include <map>
#include <stdexcept>
#include <iostream>
#include <sstream>

// Qt headers...
#include <QString>

// regmas headers..
#include "BaseClass.h"

using namespace std;

struct forData;
struct prodData;
class Pixel;

class ModelRegion : public BaseClass{

public:
            ModelRegion(ThreadManager* MTHREAD_h, int regId_h, string regSName_h, string regLName_h, int regLevel_h, int parRegId_h, bool isResidual_h); ///< Constructor
             ~ModelRegion();

  // "set" methods..
  void                setRegId(int regId_h){regId = regId_h;};
  void                setRegSName(string regSName_h){regSName = regSName_h;};
  void                setRegLName(string regLName_h){regLName = regLName_h;};
  void                setRegLevel(int regLevel_h){regLevel = regLevel_h;};
  void                setParRegId(int parRegId_h){parRegId = parRegId_h;};
  void                setIsResidual(bool isResidual_h){isResidual = isResidual_h;};
  void                setParent(ModelRegion* parRegion_h){parRegion = parRegion_h;};
  void                setChildren(vector<ModelRegion*> children_h) {chRegions = children_h;}; ///< Childrens are all the lvel-1 region that are parts of this region.
  void                addForData(forData* data_h){forDataVector.push_back(data_h);};
  void                addProdData(prodData* data_h){prodDataVector.push_back(data_h);};
  void                setMyPixels(); ///< It sets a double link pixels <--> region
  void                swap(const int& swap_what);

  // "get" methods..
  int                 getRegId()      const {return regId;};
  string              getRegSName()   const {return regSName;};
  string              getRegLName()   const {return regLName;};
  int                 getRegLevel()   const {return regLevel;};
  int                 getParRegId()   const {return parRegId;};
  bool                getIsResidual() const {return isResidual;};
  ModelRegion*        getParent(){return parRegion;}; ///< Returns a pointer to the parent regions
  vector<ModelRegion*>getChildren(bool excludeResidual = true); ///< Return a vector of pointers to the direct child regions
  vector<ModelRegion*>getSiblings(bool excludeResidual = true); ///< Return a vector of pointers to the siblings regions
  double              getVolumes();
  vector<double>      getVolumes(int fType_h);
  double              getValue(string layerName, int op=OP_SUM); ///< return the values of its own pixels for the specified layer. Possible operations: OP_SUM or OP_AVG
  vector < vector <double> > getVolumes(int fType_h, string dClass_h);
  double              getArea(const string &fType_h, const string &dClass_h); ///< Get area by ft and dc (from pixel->area matrix)
  double              getArea(const string &fType_h); ///< Get area by ft (from pixel->area matrix)
  double              getArea(const int& ft_pos, const int& dc_pos); ///< Get area by ft and dc positions (from pixel->area matrix)
  double              getArea(const int& ft_pos); ///< Get area by ft position (from pixel->area matrix)
  double              getArea(); ///< Get whole forest area (from pixel->area matrix)

  int                 getNChildren(bool excludeResidual = true);
  vector<Pixel*>      getMyPixels(){return myPixels;};

  vector<double>     inResByAnyCombination;             ///< Vector of inventory resource for each possible combination of primary products. This store both alive timber and death one.
  //vector<double>     inResByAnyCombination_deathTimber; ///< Vector of inventory resource for each possible combination of primary products. This store only death timber.

private:
  int                                regId; ///< Regional unique ID
  string                          regSName; ///< A short name of the region
  string                          regLName; ///< Region long name;
  int                             regLevel; ///< The level of the region. 1: country, 2: regions
  int                             parRegId; ///< Id of the parent region;
  bool                          isResidual; ///< A flag if this region should be explicitelly modelled or it is just a residual
  ModelRegion*                   parRegion; ///< Pointer to the parent region
  vector<ModelRegion*>           chRegions; ///< Vector of level-1 children regions
  vector<forData*>           forDataVector; ///< Vector of pointers of forestry data (owned by ModelData)
  vector<prodData*>         prodDataVector; ///< Vector of pointers of product data (owned by ModelData)
  vector<Pixel*>                  myPixels; ///< Vector of pixels for this region



};

#endif // REGION_H
